IF  EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_LIBERA_PGTO_CONV]') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))

DROP FUNCTION [dbo].[UFD_EST_PROD_LIBERA_PGTO_CONV]
GO

CREATE FUNCTION UFD_EST_PROD_LIBERA_PGTO_CONV(@CD_EMP INT, @CD_FILIAL INT, @CD_PROD INT, @CD_CLI INT, @CD_CONV INT, @IS_RECEITA INT)
RETURNS INT
AS 
BEGIN

	-- SELECT * FROM UFD_EST_PROD_LIBERA_PGTO_CONV(1, 2, 3, 101, 1 , 0)

	DECLARE @CD_PLANO_VENDA                   INT = 0
	DECLARE @LIBERA_VD_CONV                   INT = 0

	-- VALIDANDO BLOQUEIO DE VENDA EM FILIAL
	IF NOT EXISTS ( SELECT CD_FILIAL FROM RC_CLI_CONV_PRC_FILIAL_BLQ WHERE	CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_CONV = @CD_CONV ) BEGIN
		SET @LIBERA_VD_CONV = 1;

		-------------------------------------------------------------------------------------------------------------------------------    
		--DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO    
		-------------------------------------------------------------------------------------------------------------------------------    
		DECLARE @EST_PROD_ARV_MERC TABLE (  CD_EMP     INT,    
											CD_PROD     INT,    
											CD_ARV_MERC_CATEG  INT,    
											CD_ARV_MERC_LINHA  INT,    
											CD_MC     INT,    
											CD_ARV_MERC_FAMILIA  INT,            
											CD_FABRIC    INT)    

		IF @CD_CONV > 0
		BEGIN
			-------------------------------------------------------------------------------------------------------------------------------    
			--BUSCANDO ARVORE MERC. DO PRODUTO    
			-------------------------------------------------------------------------------------------------------------------------------     
			INSERT INTO @EST_PROD_ARV_MERC    			
				SELECT     
					ARV.CD_EMP     ,    
					ARV.CD_PROD     ,    
					ARV.CD_ARV_MERC_CATEG  ,    
					ARV.CD_ARV_MERC_LINHA  ,    
					ARV.CD_MC     ,    
					ARV.CD_ARV_MERC_FAMILIA  ,            
					P.CD_FABRIC     
				FROM EST_PROD_EST_ARV_MERCADOLOGICA ARV 
						INNER JOIN EST_PROD P ON    
							ARV.CD_EMP  = P.CD_EMP    
							AND ARV.CD_PROD = P.CD_PROD    
				WHERE   P.CD_EMP = @CD_EMP     
						AND P.CD_PROD = @CD_PROD 


			-------------------------------------------------------------------------------------------------------------------------------    
			--EXISTE ARVORE MERCADOLOGICA    
			-------------------------------------------------------------------------------------------------------------------------------     
			IF EXISTS(SELECT 1 FROM @EST_PROD_ARV_MERC)
			BEGIN
				SET @CD_PLANO_VENDA = COALESCE( 
										(	SELECT
												COALESCE(RC_CLI.CD_PLANO_VENDA,0)
											FROM	RC_CLI 	
											WHERE	@CD_EMP = RC_CLI.CD_EMP AND 
													@CD_CLI = RC_CLI.CD_CLI
										), 0
									)

				

				-- VERIFICANDO SE LINHA ESTA BLOQUEADA
					SET @LIBERA_VD_CONV = COALESCE((  
											SELECT
													CASE WHEN @IS_RECEITA <> 0 AND BLQ_LINHA.FLAG_CRM = 1 THEN 1 ELSE 0 END AS LIBERA_VD_CONV
											FROM 
													RC_CLI_CONV_RC_CLI_CONV_BLOQ_LINHA AS VINC_LINHA 
													INNER JOIN RC_CLI_CONV_BLOQ_LINHA_EST_ARV_MERC_LINHA AS BLQ_LINHA ON
														VINC_LINHA.CD_EMP = BLQ_LINHA.CD_EMP AND 
														VINC_LINHA.CD_CTR 	= BLQ_LINHA.CD_CTR
													INNER JOIN @EST_PROD_ARV_MERC ARV ON    
														BLQ_LINHA.CD_EMP = ARV.CD_EMP AND       
														BLQ_LINHA.CD_ARV_MERC_LINHA = ARV.CD_ARV_MERC_LINHA
											WHERE	VINC_LINHA.CD_EMP 			= @CD_EMP AND 
													VINC_LINHA.CD_CONV 			= @CD_CONV AND 
													VINC_LINHA.CD_PLANO_VENDA 	= @CD_PLANO_VENDA)
										, 1)

					-- VERIFICANDO BLOQUEIO OU LIBERACAO DO CATEGORIA PRODUTO
					SET @LIBERA_VD_CONV = COALESCE((  
											SELECT 
													MAX(CASE WHEN COALESCE(BLQ_CATGO_CAB.TP_OP,0) = 0 THEN
															CASE WHEN @IS_RECEITA <> 0 AND BLQ_CATGO.FLAG_CRM = 1 THEN 1 ELSE 0 END 
														ELSE
															BLQ_CATGO_CAB.TP_OP
														END) AS LIBERA_VD_CONV
											FROM 
													RC_CLI_CONV_RC_CLI_CONV_BLOQ_LIBERA_CATGO AS VINC_CATGO
													INNER JOIN RC_CLI_CONV_BLOQ_LIBERA_CATGO AS BLQ_CATGO_CAB ON 
														VINC_CATGO.CD_EMP = BLQ_CATGO_CAB.CD_EMP AND 
														VINC_CATGO.CD_CTR = BLQ_CATGO_CAB.CD_CTR
													INNER JOIN RC_CLI_CONV_BLOQ_LIBERA_CATGO_EST_ARV_MERC_CATEGORIA AS BLQ_CATGO ON
														BLQ_CATGO_CAB.CD_EMP = BLQ_CATGO.CD_EMP AND 
														BLQ_CATGO_CAB.CD_CTR = BLQ_CATGO.CD_CTR
													INNER JOIN @EST_PROD_ARV_MERC ARV ON    
														BLQ_CATGO.CD_EMP  = ARV.CD_EMP AND       
														BLQ_CATGO.CD_CATEG = ARV.CD_ARV_MERC_CATEG
											WHERE 
													VINC_CATGO.CD_EMP		  = @CD_EMP AND 
													VINC_CATGO.CD_CONV		  = @CD_CONV AND 
													VINC_CATGO.CD_PLANO_VENDA = @CD_PLANO_VENDA), @LIBERA_VD_CONV)

					-- VERIFICANDO BLOQUEIO OU LIBERACAO DO PRODUTO
					SET @LIBERA_VD_CONV = COALESCE((  
											SELECT 
													MAX(CASE WHEN COALESCE(BLQ_PROD_CAB.TP_OP,0) = 0 THEN
															CASE WHEN @IS_RECEITA <> 0 AND BLQ_PROD.FLAG_CRM = 1 THEN 1 ELSE 0 END 
														ELSE
															BLQ_PROD_CAB.TP_OP
														END) AS LIBERA_VD_CONV
											FROM 
													RC_CLI_CONV_RC_CLI_CONV_BLOQ_LIBERA_PROD AS VINC_PROD
													INNER JOIN RC_CLI_CONV_BLOQ_LIBERA_PROD AS BLQ_PROD_CAB ON 
														VINC_PROD.CD_EMP     = BLQ_PROD_CAB.CD_EMP AND 
														VINC_PROD.CD_CTR = BLQ_PROD_CAB.CD_CTR
													INNER JOIN RC_CLI_CONV_BLOQ_LIBERA_PROD_EST_PROD AS BLQ_PROD ON
														BLQ_PROD_CAB.CD_EMP     = BLQ_PROD.CD_EMP AND 
														BLQ_PROD_CAB.CD_CTR = BLQ_PROD.CD_CTR
													INNER JOIN @EST_PROD_ARV_MERC ARV ON    
														BLQ_PROD.CD_EMP = ARV.CD_EMP AND       
														BLQ_PROD.CD_PROD = ARV.CD_PROD	
											WHERE 
													VINC_PROD.CD_EMP		 = @CD_EMP AND 
													VINC_PROD.CD_CONV		 = @CD_CONV AND 
													VINC_PROD.CD_PLANO_VENDA = @CD_PLANO_VENDA), @LIBERA_VD_CONV)

					
			END	

		END
	END
		

	RETURN @LIBERA_VD_CONV
END

